﻿using System;
using System.Linq;
using VA.TMP.DataModel;
using VA.TMP.Integration.VIMT.VideoVisit.StateObject;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.VideoVisit.PipelineSteps.Create
{
    /// <summary>
    /// Connect to CRM step.
    /// </summary>
    public class GetServiceAppointmentStep : FilterBase<VideoVisitCreateStateObject>
    {
        /// <summary>
        /// Execute the step.
        /// </summary>
        /// <param name="state">State object.</param>
        public override void Execute(VideoVisitCreateStateObject state)
        {
            using (var srv = new Xrm(state.OrganizationServiceProxy))
            {
                state.ServiceAppointment = srv.ServiceAppointmentSet.FirstOrDefault(x => x.Id == state.AppointmentId);
                if (state.ServiceAppointment == null) throw new Exception(string.Format("Unable to retrieve Service Appointment - {0}", state.AppointmentId));

                // Look up the first booked contact(patient) in the customers party list. 
                var bookedPatient = state.ServiceAppointment.Customers.FirstOrDefault(p => p.PartyId.LogicalName == "contact");
                if (bookedPatient == null) throw new Exception("Unable to retrieve Patient Data");
                state.Contact = srv.ContactSet.FirstOrDefault(i => i.Id == bookedPatient.PartyId.Id);

                // Look up the first booked system user in the resources party list.                
                var bookedSysUser = state.ServiceAppointment.Resources.FirstOrDefault(r => r.PartyId.LogicalName == "systemuser");
                if (bookedSysUser == null) throw new Exception("Unable to retrieve Provider Data");
                state.SystemUser = srv.SystemUserSet.FirstOrDefault(i => i.Id == bookedSysUser.PartyId.Id);
            }
        }
    }
}